/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.pc;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.CobblemonUnlockableWallpapers;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.storage.WallpaperUnlockedEvent;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.BottomlessStore;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.UnlockablePCWallpaper;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.api.toast.Toast;
import com.cobblemon.mod.common.net.messages.client.storage.RemoveClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.SwapClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.InitializePCPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.MoveClientPCPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.SetPCPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.wallpaper.UnlockPCBoxWallpaperPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.JsonExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0017\u0010\tJ\u0011\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0015J\u000f\u0010\u001f\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u000b\u00a2\u0006\u0004\b\"\u0010#J5\u0010)\u001a\u00020\u00132\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\u001b2\u0014\b\u0002\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130'\u00a2\u0006\u0004\b)\u0010*J;\u0010-\u001a\u00020\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u000e2\b\b\u0002\u0010&\u001a\u00020\u001b2\u0014\b\u0002\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130'\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\u0013\u00a2\u0006\u0004\b/\u0010 J\u001f\u00104\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b4\u00105J%\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u00101\u001a\u0002002\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020\u0013\u00a2\u0006\u0004\b8\u0010 J\u001f\u0010;\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b;\u0010<J%\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010:\u001a\u0002092\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b=\u0010>J \u0010?\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010A\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bA\u0010BJ\u001f\u0010E\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bE\u0010FJ\u001d\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00020G2\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\bH\u0010IJ\u001f\u0010J\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\bJ\u0010KJ\u0015\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00130LH\u0016\u00a2\u0006\u0004\bM\u0010NJ!\u0010O\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\bO\u0010@J\u001a\u0010P\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\bP\u0010QJ\u0017\u0010R\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bR\u0010#J\r\u0010S\u001a\u00020\u0013\u00a2\u0006\u0004\bS\u0010 J\u001b\u0010W\u001a\u00020\u00132\f\u0010V\u001a\b\u0012\u0004\u0012\u00020U0T\u00a2\u0006\u0004\bW\u0010XJ\u001f\u0010[\u001a\u00020\u001b2\u0006\u0010Y\u001a\u00020U2\b\b\u0002\u0010Z\u001a\u00020\u001b\u00a2\u0006\u0004\b[\u0010\\R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010]\u001a\u0004\b^\u0010_R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010`\u001a\u0004\ba\u0010bR\u001d\u0010d\u001a\b\u0012\u0004\u0012\u00020+0c8\u0006\u00a2\u0006\f\n\u0004\bd\u0010e\u001a\u0004\bf\u0010\u0011R\"\u0010g\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u0017\u0010n\u001a\u00020m8\u0006\u00a2\u0006\f\n\u0004\bn\u0010o\u001a\u0004\bp\u0010qR\u001d\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00030r8\u0006\u00a2\u0006\f\n\u0004\bs\u0010t\u001a\u0004\bu\u0010vR\u001d\u0010w\u001a\b\u0012\u0004\u0012\u00020U0r8\u0006\u00a2\u0006\f\n\u0004\bw\u0010t\u001a\u0004\bx\u0010vR\u001d\u0010y\u001a\b\u0012\u0004\u0012\u00020U0r8\u0006\u00a2\u0006\f\n\u0004\by\u0010t\u001a\u0004\bz\u0010vR\u001d\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00000{8\u0006\u00a2\u0006\f\n\u0004\b|\u0010}\u001a\u0004\b~\u0010\u007fR!\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u00130L8\u0006\u00a2\u0006\u000f\n\u0006\b\u0080\u0001\u0010\u0081\u0001\u001a\u0005\b\u0082\u0001\u0010N\u00a8\u0006\u0083\u0001"}, d2={"Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_5250;", "name", "<init>", "(Ljava/util/UUID;Lnet/minecraft/class_5250;)V", "(Ljava/util/UUID;)V", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "iterator", "()Ljava/util/Iterator;", "", "Lnet/minecraft/class_3222;", "getObservingPlayers", "()Ljava/util/List;", "player", "", "addObserver", "(Lnet/minecraft/class_3222;)V", "playerID", "removeObserver", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "position", "", "isValidPosition", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)Z", "sendTo", "initialize", "()V", "pokemon", "relocateEvictedBoxPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "newSize", "lockNewSize", "Lkotlin/Function1;", "overflowHandler", "resize", "(IZLkotlin/jvm/functions/Function1;)V", "Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "boxList", "removeListOfBoxes", "(Ljava/util/List;ZLkotlin/jvm/functions/Function1;)V", "tryRestoreBackedUpPokemon", "Lnet/minecraft/class_2487;", "nbt", "Lnet/minecraft/class_5455;", "registryAccess", "saveToNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lnet/minecraft/class_2487;", "loadFromNBT", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "removeDuplicates", "Lcom/google/gson/JsonObject;", "json", "saveToJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "set", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "remove", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "position1", "position2", "swap", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)V", "Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "loadPositionFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "savePositionToNBT", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;Lnet/minecraft/class_2487;)V", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getAnyChangeObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "setAtPosition", "get", "(Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "onPokemonChanged", "clearPC", "", "Lnet/minecraft/class_2960;", "textures", "markWallpapersSeen", "(Ljava/util/Set;)V", "wallpaper", "playSound", "unlockWallpaper", "(Lnet/minecraft/class_2960;Z)Z", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "", "boxes", "Ljava/util/List;", "getBoxes", "lockedSize", "Z", "getLockedSize", "()Z", "setLockedSize", "(Z)V", "Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "backupStore", "Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "getBackupStore", "()Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "", "observingUUIDs", "Ljava/util/Set;", "getObservingUUIDs", "()Ljava/util/Set;", "unlockedWallpapers", "getUnlockedWallpapers", "unseenWallpapers", "getUnseenWallpapers", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "struct", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "getStruct", "()Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "pcChangeObservable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getPcChangeObservable", "common"})
@SourceDebugExtension(value={"SMAP\nPCStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PCStore.kt\ncom/cobblemon/mod/common/api/storage/pc/PCStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable$postThen$1\n*L\n1#1,350:1\n1374#2:351\n1460#2,5:352\n1617#2,9:357\n1869#2:366\n1870#2:368\n1626#2:369\n1869#2:370\n1870#2:372\n1869#2,2:373\n1869#2,2:375\n1374#2:377\n1460#2,5:378\n1869#2,2:383\n1374#2:385\n1460#2,5:386\n1869#2,2:391\n1878#2,3:393\n1563#2:396\n1634#2,3:397\n1563#2:400\n1634#2,3:401\n1563#2:404\n1634#2,3:405\n1563#2:408\n1634#2,3:409\n1878#2,3:412\n1563#2:415\n1634#2,3:416\n1563#2:419\n1634#2,3:420\n1563#2:423\n1634#2,3:424\n1563#2:427\n1634#2,3:428\n1869#2:431\n1870#2:434\n1617#2,9:435\n1869#2:444\n1870#2:446\n1626#2:447\n774#2:448\n865#2,2:449\n1563#2:451\n1634#2,3:452\n1869#2:464\n1870#2:466\n1#3:367\n1#3:371\n1#3:445\n1#3:465\n216#4,2:432\n39#5,2:455\n41#5,2:460\n44#5:463\n46#5:467\n47#5:470\n17#6,2:457\n19#6:469\n13805#7:459\n13806#7:468\n39#8:462\n*S KotlinDebug\n*F\n+ 1 PCStore.kt\ncom/cobblemon/mod/common/api/storage/pc/PCStore\n*L\n76#1:351\n76#1:352,5\n77#1:357,9\n77#1:366\n77#1:368\n77#1:369\n92#1:370\n92#1:372\n102#1:373,2\n106#1:375,2\n129#1:377\n129#1:378,5\n129#1:383,2\n144#1:385\n144#1:386,5\n144#1:391,2\n160#1:393,3\n164#1:396\n164#1:397,3\n165#1:400\n165#1:401,3\n184#1:404\n184#1:405,3\n187#1:408\n187#1:409,3\n210#1:412,3\n214#1:415\n214#1:416,3\n215#1:419\n215#1:420,3\n234#1:423\n234#1:424,3\n237#1:427\n237#1:428,3\n301#1:431\n301#1:434\n310#1:435,9\n310#1:444\n310#1:446\n310#1:447\n312#1:448\n312#1:449,2\n314#1:451\n314#1:452,3\n329#1:464\n329#1:466\n77#1:367\n310#1:445\n302#1:432,2\n323#1:455,2\n323#1:460,2\n323#1:463\n323#1:467\n323#1:470\n323#1:457,2\n323#1:469\n323#1:459\n323#1:468\n323#1:462\n*E\n"})
public class PCStore
extends PokemonStore<PCPosition> {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final class_5250 name;
    @NotNull
    private final List<PCBox> boxes;
    private boolean lockedSize;
    @NotNull
    private final BottomlessStore backupStore;
    @NotNull
    private final Set<UUID> observingUUIDs;
    @NotNull
    private final Set<class_2960> unlockedWallpapers;
    @NotNull
    private final Set<class_2960> unseenWallpapers;
    @NotNull
    private final ObjectValue<PCStore> struct;
    @NotNull
    private final SimpleObservable<Unit> pcChangeObservable;

    public PCStore(@NotNull UUID uuid, @NotNull class_5250 name) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.uuid = uuid;
        this.name = name;
        this.boxes = new ArrayList();
        this.backupStore = new BottomlessStore(new UUID(0L, 0L));
        Object[] objectArray = new UUID[]{this.uuid};
        this.observingUUIDs = SetsKt.mutableSetOf((Object[])objectArray);
        this.unlockedWallpapers = new LinkedHashSet();
        this.unseenWallpapers = new LinkedHashSet();
        this.struct = MoLangFunctions.INSTANCE.asMoLangValue(this);
        this.pcChangeObservable = new SimpleObservable();
    }

    @Override
    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final class_5250 getName() {
        return this.name;
    }

    public PCStore(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        class_5250 class_52502 = LocalizationUtilsKt.lang("your_pc", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
        this(uuid, class_52502);
    }

    @NotNull
    public final List<PCBox> getBoxes() {
        return this.boxes;
    }

    protected final boolean getLockedSize() {
        return this.lockedSize;
    }

    protected final void setLockedSize(boolean bl) {
        this.lockedSize = bl;
    }

    @NotNull
    public final BottomlessStore getBackupStore() {
        return this.backupStore;
    }

    @NotNull
    public final Set<UUID> getObservingUUIDs() {
        return this.observingUUIDs;
    }

    @NotNull
    public final Set<class_2960> getUnlockedWallpapers() {
        return this.unlockedWallpapers;
    }

    @NotNull
    public final Set<class_2960> getUnseenWallpapers() {
        return this.unseenWallpapers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.boxes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PCBox it = (PCBox)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.toList((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return ((List)destination$iv$iv).iterator();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<class_3222> getObservingPlayers() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.observingUUIDs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (PlayerExtensionsKt.getPlayer(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ObjectValue<PCStore> getStruct() {
        return this.struct;
    }

    public final void addObserver(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.observingUUIDs.add(uUID);
        this.sendTo(player);
    }

    public final void removeObserver(@NotNull UUID playerID) {
        Intrinsics.checkNotNullParameter((Object)playerID, (String)"playerID");
        this.observingUUIDs.remove(playerID);
    }

    @NotNull
    public final SimpleObservable<Unit> getPcChangeObservable() {
        return this.pcChangeObservable;
    }

    @Override
    @Nullable
    public PCPosition getFirstAvailablePosition() {
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox it = (PCBox)element$iv;
            boolean bl = false;
            PCPosition pCPosition = it.getFirstAvailablePosition();
            if (pCPosition == null) continue;
            PCPosition it2 = pCPosition;
            boolean bl2 = false;
            return it2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValidPosition(@NotNull PCPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int n = this.boxes.size();
        int n2 = position.getBox();
        if (0 > n2) return false;
        if (n2 >= n) return false;
        boolean bl = true;
        if (!bl) return false;
        n = position.getSlot();
        if (0 > n) return false;
        if (n >= 30) return false;
        return true;
    }

    @Override
    public void sendTo(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new InitializePCPacket(this).sendToPlayer(player);
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox it = (PCBox)element$iv;
            boolean bl = false;
            it.sendTo(player);
        }
    }

    @Override
    public void initialize() {
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox it = (PCBox)element$iv;
            boolean bl = false;
            it.initialize();
        }
        this.backupStore.initialize();
    }

    public final void relocateEvictedBoxPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        PCPosition space = this.getFirstAvailablePosition();
        if (space != null) {
            this.set(space, pokemon);
        } else {
            this.backupStore.add(pokemon);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void resize(int newSize, boolean lockNewSize, @NotNull Function1<? super Pokemon, Unit> overflowHandler) {
        Intrinsics.checkNotNullParameter(overflowHandler, (String)"overflowHandler");
        if (newSize <= 0) {
            throw new IllegalArgumentException("Invalid box count: Must be greater than zero.");
        }
        this.lockedSize = lockNewSize;
        if (this.boxes.size() > newSize) {
            void $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            List slicedBoxes = CollectionsKt.slice(this.boxes, (IntRange)RangesKt.until((int)newSize, (int)this.boxes.size()));
            this.boxes.removeAll(slicedBoxes);
            Iterable $this$flatMap$iv = slicedBoxes;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PCBox it = (PCBox)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                overflowHandler.invoke(element$iv);
            }
        } else {
            while (this.boxes.size() < newSize) {
                this.boxes.add(new PCBox(this));
            }
            this.tryRestoreBackedUpPokemon();
        }
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.pcChangeObservable.emit((Unit[])unitArray);
    }

    public static /* synthetic */ void resize$default(PCStore pCStore, int n, boolean bl, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resize");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            function1 = (Function1)new Function1<Pokemon, Unit>((Object)pCStore){

                public final void invoke(Pokemon p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((PCStore)this.receiver).relocateEvictedBoxPokemon(p0);
                }
            };
        }
        pCStore.resize(n, bl, (Function1<? super Pokemon, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeListOfBoxes(@NotNull List<? extends PCBox> boxList, boolean lockNewSize, @NotNull Function1<? super Pokemon, Unit> overflowHandler) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(boxList, (String)"boxList");
        Intrinsics.checkNotNullParameter(overflowHandler, (String)"overflowHandler");
        this.lockedSize = lockNewSize;
        this.boxes.removeAll((Collection)boxList);
        Iterable $this$flatMap$iv = boxList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PCBox it = (PCBox)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            overflowHandler.invoke(element$iv);
        }
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.pcChangeObservable.emit((Unit[])unitArray);
    }

    public static /* synthetic */ void removeListOfBoxes$default(PCStore pCStore, List list, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeListOfBoxes");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<Pokemon, Unit>((Object)pCStore){

                public final void invoke(Pokemon p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((PCStore)this.receiver).relocateEvictedBoxPokemon(p0);
                }
            };
        }
        pCStore.removeListOfBoxes(list, bl, (Function1<? super Pokemon, Unit>)function1);
    }

    public final void tryRestoreBackedUpPokemon() {
        PCPosition newPosition = this.getFirstAvailablePosition();
        List backedUpPokemon = CollectionsKt.toMutableList((Collection)this.backupStore.getPokemon());
        while (newPosition != null && !((Collection)backedUpPokemon).isEmpty()) {
            this.set(newPosition, (Pokemon)backedUpPokemon.remove(0));
            newPosition = this.getFirstAvailablePosition();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 nbt, @NotNull class_5455 registryAccess) {
        class_2960 it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        class_2499 it2;
        class_2499 class_24992;
        void box;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        nbt.method_10575("BoxCount", (short)this.boxes.size());
        nbt.method_10556("BoxCountLocked", this.lockedSize);
        Iterable $this$forEachIndexed$iv = this.boxes;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PCBox pCBox = (PCBox)item$iv;
            int index = n;
            boolean bl = false;
            nbt.method_10566("Box" + index, (class_2520)box.saveToNBT(new class_2487(), registryAccess));
        }
        nbt.method_10566("BackupStore", (class_2520)this.backupStore.saveToNBT(new class_2487(), registryAccess));
        class_2499 $i$f$forEachIndexed22 = class_24992 = new class_2499();
        String string = "UnlockedWallpapers";
        class_2487 class_24872 = nbt;
        boolean bl = false;
        Iterable iterable = this.unlockedWallpapers;
        class_2499 class_24993 = it2;
        boolean $i$f$map = false;
        box = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            class_2960 class_29602 = (class_2960)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(class_2519.method_23256((String)it.toString()));
        }
        class_24993.addAll((Collection)((List)destination$iv$iv));
        Unit unit = Unit.INSTANCE;
        class_24872.method_10566(string, (class_2520)class_24992);
        it2 = class_24992 = new class_2499();
        string = "UnseenWallpapers";
        class_24872 = nbt;
        boolean bl3 = false;
        $this$map$iv = this.unseenWallpapers;
        class_24993 = it2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (class_2960)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(class_2519.method_23256((String)it.toString()));
        }
        class_24993.addAll((Collection)((List)destination$iv$iv));
        unit = Unit.INSTANCE;
        class_24872.method_10566(string, (class_2520)class_24992);
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PokemonStore<PCPosition> loadFromNBT(@NotNull class_2487 nbt, @NotNull class_5455 registryAccess) {
        class_2520 it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Set<class_2960> set;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        int boxCountStored = nbt.method_10568("BoxCount");
        int n = boxCountStored;
        for (int boxNumber = 0; boxNumber < n; ++boxNumber) {
            PCBox pCBox = new PCBox(this);
            class_2487 class_24872 = nbt.method_10562("Box" + boxNumber);
            Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
            this.boxes.add(pCBox.loadFromNBT(class_24872, registryAccess));
        }
        this.lockedSize = nbt.method_10577("BoxCountLocked");
        if (!this.lockedSize && this.boxes.size() != Cobblemon.INSTANCE.getConfig().getDefaultBoxCount()) {
            PCStore.resize$default(this, Cobblemon.INSTANCE.getConfig().getDefaultBoxCount(), false, null, 4, null);
        } else {
            this.tryRestoreBackedUpPokemon();
        }
        this.removeDuplicates();
        if (nbt.method_10545("UnlockedWallpapers")) {
            void $this$map$iv;
            class_2499 class_24992 = nbt.method_10554("UnlockedWallpapers", 8);
            Intrinsics.checkNotNullExpressionValue((Object)class_24992, (String)"getList(...)");
            Iterable boxNumber = (Iterable)class_24992;
            set = this.unlockedWallpapers;
            $i$f$map = false;
            void var6_9 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                class_2520 class_25202 = (class_2520)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(class_2960.method_60654((String)it.method_10714()));
            }
            set.addAll((List)destination$iv$iv);
        }
        if (nbt.method_10545("UnseenWallpapers")) {
            class_2499 class_24993 = nbt.method_10554("UnseenWallpapers", 8);
            Intrinsics.checkNotNullExpressionValue((Object)class_24993, (String)"getList(...)");
            Iterable $this$map$iv = (Iterable)class_24993;
            set = this.unseenWallpapers;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (class_2520)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(class_2960.method_60654((String)it.method_10714()));
            }
            set.addAll((List)destination$iv$iv);
        }
        return this;
    }

    public final void removeDuplicates() {
        List knownUUIDs = new ArrayList();
        for (PCBox box : this.boxes) {
            for (int i = 0; i < 30; ++i) {
                Pokemon pokemon;
                if (box.get(i) == null) continue;
                if (!knownUUIDs.contains(pokemon.getUuid())) {
                    UUID uUID = pokemon.getUuid();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
                    knownUUIDs.add(uUID);
                    continue;
                }
                box.set(i, null);
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.pcChangeObservable.emit((Unit[])unitArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json, @NotNull class_5455 registryAccess) {
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        json.addProperty("BoxCount", (Number)((short)this.boxes.size()));
        json.addProperty("BoxCountLocked", Boolean.valueOf(this.lockedSize));
        Iterable $this$forEachIndexed$iv = this.boxes;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void box;
            int n;
            if ((n = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PCBox pCBox = (PCBox)item$iv;
            int index = n;
            boolean bl = false;
            json.add("Box" + index, (JsonElement)box.saveToJSON(new JsonObject(), registryAccess));
        }
        json.add("BackupStore", (JsonElement)this.backupStore.saveToJSON(new JsonObject(), registryAccess));
        $this$forEachIndexed$iv = this.unlockedWallpapers;
        String string = "UnlockedWallpapers";
        JsonObject jsonObject = json;
        boolean $i$f$map = false;
        void index$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            class_2960 index = (class_2960)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        collection = (List)destination$iv$iv;
        jsonObject.add(string, (JsonElement)JsonExtensionsKt.toJsonArrayString(collection));
        $this$map$iv = this.unseenWallpapers;
        string = "UnseenWallpapers";
        jsonObject = json;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            class_2960 p0 = (class_2960)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        collection = (List)destination$iv$iv;
        jsonObject.add(string, (JsonElement)JsonExtensionsKt.toJsonArrayString(collection));
        return json;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PokemonStore<PCPosition> loadFromJSON(@NotNull JsonObject json, @NotNull class_5455 registryAccess) {
        JsonElement it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Set<class_2960> set;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        int boxCountStored = json.get("BoxCount").getAsShort();
        int n = boxCountStored;
        for (int boxNumber = 0; boxNumber < n; ++boxNumber) {
            PCBox pCBox = new PCBox(this);
            JsonObject jsonObject = json.getAsJsonObject("Box" + boxNumber);
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            this.boxes.add(pCBox.loadFromJSON(jsonObject, registryAccess));
        }
        this.lockedSize = json.get("BoxCountLocked").getAsBoolean();
        if (!this.lockedSize && this.boxes.size() != Cobblemon.INSTANCE.getConfig().getDefaultBoxCount()) {
            PCStore.resize$default(this, Cobblemon.INSTANCE.getConfig().getDefaultBoxCount(), false, null, 4, null);
        } else {
            this.tryRestoreBackedUpPokemon();
        }
        this.removeDuplicates();
        if (json.has("UnlockedWallpapers")) {
            void $this$map$iv;
            JsonArray jsonArray = json.getAsJsonArray("UnlockedWallpapers");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable boxNumber = (Iterable)jsonArray;
            set = this.unlockedWallpapers;
            $i$f$map = false;
            void var6_9 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(class_2960.method_60654((String)it.getAsString()));
            }
            set.addAll((List)destination$iv$iv);
        }
        if (json.has("UnseenWallpapers")) {
            JsonArray jsonArray = json.getAsJsonArray("UnseenWallpapers");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$map$iv = (Iterable)jsonArray;
            set = this.unseenWallpapers;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JsonElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(class_2960.method_60654((String)it.getAsString()));
            }
            set.addAll((List)destination$iv$iv);
        }
        return this;
    }

    @Override
    public void set(@NotNull PCPosition position, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        super.set((StorePosition)position, pokemon);
        this.sendPacketToObservers(new SetPCPokemonPacket(this.uuid, position, (Function1<? super class_5455, ? extends Pokemon>)((Function1)arg_0 -> PCStore.set$lambda$0(pokemon, arg_0))));
    }

    @Override
    public boolean remove(@NotNull Pokemon pokemon) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (super.remove(pokemon)) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new RemoveClientPokemonPacket(pokemonStore, uUID));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void swap(@NotNull PCPosition position1, @NotNull PCPosition position2) {
        Intrinsics.checkNotNullParameter((Object)position1, (String)"position1");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position2");
        Pokemon pokemon1 = this.get(position1);
        Pokemon pokemon2 = this.get(position2);
        super.swap((StorePosition)position1, (StorePosition)position2);
        if (pokemon1 != null && pokemon2 != null) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon1.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            UUID uUID2 = pokemon2.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new SwapClientPokemonPacket(pokemonStore, uUID, uUID2));
        } else if (pokemon1 != null || pokemon2 != null) {
            PCPosition newPosition = pokemon1 == null ? position1 : position2;
            Pokemon pokemon = pokemon1;
            if (pokemon == null) {
                Pokemon pokemon3 = pokemon2;
                pokemon = pokemon3;
                Intrinsics.checkNotNull((Object)pokemon3);
            }
            Pokemon pokemon4 = pokemon;
            UUID uUID = pokemon4.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            this.sendPacketToObservers(new MoveClientPCPokemonPacket(this.uuid, uUID, newPosition));
        }
    }

    @Override
    @NotNull
    public StoreCoordinates<PCPosition> loadPositionFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return new StoreCoordinates<StorePosition>(this, new PCPosition(nbt.method_10568("Box"), nbt.method_10571("Slot")));
    }

    @Override
    public void savePositionToNBT(@NotNull PCPosition position, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.method_10575("Box", (short)position.getBox());
        nbt.method_10567("Slot", (byte)position.getSlot());
    }

    @NotNull
    public SimpleObservable<Unit> getAnyChangeObservable() {
        return this.pcChangeObservable;
    }

    @Override
    protected void setAtPosition(@NotNull PCPosition position, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int n = this.boxes.size();
        int n2 = position.getBox();
        if (!(0 <= n2 ? n2 < n : false)) {
            throw new IllegalArgumentException("Invalid box number " + position.getBox() + ". Should be between 0 and " + this.boxes.size());
        }
        this.boxes.get(position.getBox()).set(position.getSlot(), pokemon);
    }

    @Override
    @Nullable
    public Pokemon get(@NotNull PCPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int n = this.boxes.size();
        int n2 = position.getBox();
        return !(0 <= n2 ? n2 < n : false) ? null : this.boxes.get(position.getBox()).get(position.getSlot());
    }

    @Override
    public void onPokemonChanged(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.pcChangeObservable.emit((Unit[])unitArray);
    }

    public final void clearPC() {
        Iterable $this$forEach$iv = this.boxes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCBox box = (PCBox)element$iv;
            boolean bl = false;
            Map<Integer, Pokemon> $this$forEach$iv2 = box.getNonEmptySlots();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<Integer, Pokemon>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pokemon> element$iv2;
                Map.Entry<Integer, Pokemon> it = element$iv2 = iterator.next();
                boolean bl2 = false;
                this.remove((StorePosition)new PCPosition(box.getBoxNumber(), ((Number)it.getKey()).intValue()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void markWallpapersSeen(@NotNull Set<class_2960> textures) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        UnlockablePCWallpaper it;
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(textures, (String)"textures");
        Iterable $this$mapNotNull$iv = this.unseenWallpapers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<UnlockablePCWallpaper> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnlockablePCWallpaper it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            class_2960 it2 = (class_2960)element$iv$iv;
            boolean bl2 = false;
            if (CobblemonUnlockableWallpapers.INSTANCE.getUnlockableWallpapers().get(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List currentlyUnseen = (List)destination$iv$iv;
        Iterable $this$filter$iv = currentlyUnseen;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UnlockablePCWallpaper)element$iv$iv;
            boolean bl = false;
            if (!(!textures.contains(it.getTexture()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List remainingUnseen = (List)destination$iv$iv2;
        this.unseenWallpapers.clear();
        $this$filter$iv = remainingUnseen;
        Set<class_2960> set = this.unseenWallpapers;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UnlockablePCWallpaper)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getId());
        }
        set.addAll((List)destination$iv$iv2);
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.pcChangeObservable.emit((Unit[])unitArray);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean unlockWallpaper(@NotNull class_2960 wallpaper, boolean playSound) {
        boolean succeeded;
        block6: {
            void this_$iv$iv;
            void event$iv;
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)wallpaper, (String)"wallpaper");
            UnlockablePCWallpaper unlockableWallpaper = CobblemonUnlockableWallpapers.INSTANCE.getUnlockableWallpapers().get(wallpaper);
            succeeded = false;
            if (unlockableWallpaper == null || !unlockableWallpaper.getEnabled()) break block6;
            WallpaperUnlockedEvent event = new WallpaperUnlockedEvent(this, unlockableWallpaper, playSound);
            CancelableObservable<WallpaperUnlockedEvent> cancelableObservable = CobblemonEvents.WALLPAPER_UNLOCKED_EVENT;
            Cancelable cancelable = event;
            boolean $i$f$postThen = false;
            EventObservable eventObservable = (EventObservable)$this$iv;
            Cancelable[] cancelableArray = new Cancelable[]{event$iv};
            Cancelable[] events$iv$iv = cancelableArray;
            boolean $i$f$post = false;
            this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
            Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Cancelable it;
                Cancelable element$iv$iv$iv;
                Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                if (it$iv.isCanceled()) {
                    Cancelable cancelable2 = it$iv;
                    boolean bl2 = false;
                    it = cancelable2;
                    continue;
                }
                it = (WallpaperUnlockedEvent)it$iv;
                boolean bl3 = false;
                if (!this.unlockedWallpapers.add(wallpaper)) continue;
                this.unseenWallpapers.add(unlockableWallpaper.getTexture());
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.pcChangeObservable.emit((Unit[])unitArray);
                Iterable $this$forEach$iv = this.getObservingPlayers();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_3222[] class_3222Array;
                    class_2561 class_25612;
                    class_3222 player;
                    block8: {
                        block7: {
                            void it2;
                            player = (class_3222)element$iv;
                            boolean bl4 = false;
                            CobblemonNetwork.INSTANCE.sendPacket(player, new UnlockPCBoxWallpaperPacket(unlockableWallpaper.getTexture()));
                            if (!event.getShouldNotify()) continue;
                            class_5250 class_52502 = LocalizationUtilsKt.lang("wallpaper_unlocked", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
                            class_25612 = (class_2561)class_52502;
                            class_3222Array = unlockableWallpaper.getDisplayName();
                            if (class_3222Array == null) break block7;
                            class_3222[] class_3222Array2 = class_3222Array;
                            class_2561 class_25613 = class_25612;
                            boolean bl5 = false;
                            class_5250 class_52503 = TextKt.text("\"");
                            class_5250 class_52504 = MiscUtilsKt.asTranslated((String)it2);
                            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"asTranslated(...)");
                            class_5250 class_52505 = TextKt.add(TextKt.add(class_52503, (class_2561)class_52504), "\"");
                            class_25612 = class_25613;
                            class_3222Array = class_52505;
                            if (class_52505 != null) break block8;
                        }
                        class_3222Array = LocalizationUtilsKt.lang("unknown_wallpaper", new Object[0]);
                    }
                    class_3222[] class_3222Array3 = class_3222Array;
                    Intrinsics.checkNotNull((Object)class_3222Array3);
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n2 = 56;
                    int n3 = 0;
                    float f = 0.0f;
                    class_2960 class_29602 = null;
                    class_1799 class_17992 = new class_1799((class_1935)CobblemonItems.PC);
                    class_2561 class_25614 = (class_2561)class_3222Array3;
                    class_2561 class_25615 = class_25612;
                    Toast toast = new Toast(class_25615, class_25614, class_17992, class_29602, f, n3, n2, defaultConstructorMarker);
                    class_3222Array3 = new class_3222[]{player};
                    toast.addListeners(class_3222Array3);
                    toast.expireAfter(5.0f);
                    player.method_17356(CobblemonSounds.PC_WALLPAPER_UNLOCK, class_3419.field_15250, 1.0f, 1.0f);
                }
                succeeded = true;
            }
        }
        return succeeded;
    }

    public static /* synthetic */ boolean unlockWallpaper$default(PCStore pCStore, class_2960 class_29602, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: unlockWallpaper");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return pCStore.unlockWallpaper(class_29602, bl);
    }

    private static final Pokemon set$lambda$0(Pokemon $pokemon, class_5455 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pokemon;
    }
}

